import { Button } from "@/components/ui/button"
import { Card, CardContent, CardDescription, CardHeader, CardTitle } from "@/components/ui/card"
import { Input } from "@/components/ui/input"
import { Textarea } from "@/components/ui/textarea"
import { Play, Menu, ChevronRight, Users, Settings, Truck, Headphones, Wrench, Warehouse, UserCheck, Phone, Mail, MapPin } from "lucide-react"

export default function Home() {
  return (
    <div className="min-h-screen bg-white">
      {/* Header */}
      <header className="bg-white shadow-sm relative z-50">
        <div className="container mx-auto px-6 py-4">
          <div className="flex items-center justify-between">
            <div className="flex items-center space-x-2">
              <div className="w-8 h-8 bg-blue-600 rounded-md flex items-center justify-center">
                <span className="text-white font-bold text-lg">D</span>
              </div>
              <span className="text-xl font-bold text-gray-800">DUA SHANDIE BERSAUDARA</span>
            </div>

            <nav className="hidden md:flex items-center space-x-8">
              <a href="#hero" className="text-gray-700 hover:text-blue-600">Home</a>
              <a href="#about" className="text-gray-700 hover:text-blue-600">About</a>
              <a href="#services" className="text-gray-700 hover:text-blue-600">Services</a>
              <a href="#portfolio" className="text-gray-700 hover:text-blue-600">Portfolio</a>
              <a href="#contact" className="text-gray-700 hover:text-blue-600">Contact</a>
            </nav>

            <div className="flex items-center space-x-4">
              <Button variant="outline" className="bg-blue-500 text-white border-blue-500 hover:bg-blue-600">
                Login
              </Button>
              <Button variant="ghost" size="icon" className="md:hidden">
                <Menu className="h-6 w-6" />
              </Button>
            </div>
          </div>
        </div>
      </header>

      {/* Hero Section */}
      <section id="hero" className="relative h-screen flex items-center justify-center">
        <div
          className="absolute inset-0 bg-cover bg-center"
          style={{
            backgroundImage: `url('https://ext.same-assets.com/3054329260/1992103373.jpeg')`
          }}
        >
          <div className="absolute inset-0 bg-black bg-opacity-60"></div>
        </div>

        <div className="relative z-10 text-center text-white max-w-4xl px-6">
          <h1 className="text-5xl md:text-6xl font-bold mb-6">
            Better<br />
            Solutions for<br />
            Your<br />
            Business
          </h1>
          <p className="text-xl mb-8 max-w-2xl mx-auto">
            We strive to be a trusted partner, providing innovative management services that help our
            clients achieve their goals and secure a prosperous future.
          </p>
          <Button className="bg-transparent border-2 border-white text-white hover:bg-white hover:text-black transition-colors">
            <Play className="mr-2 h-4 w-4" />
            Watch Video
          </Button>
        </div>
      </section>

      {/* Clients Section */}
      <section className="py-16 bg-gray-50">
        <div className="container mx-auto px-6">
          <h2 className="text-2xl font-bold text-center mb-12 text-gray-800">OUR CLIENTS</h2>
          <div className="grid grid-cols-2 md:grid-cols-6 gap-8 items-center justify-items-center">
            <img src="https://ext.same-assets.com/3054329260/3449512699.png" alt="Client 1" className="h-12 object-contain grayscale hover:grayscale-0 transition-all" />
            <img src="https://ext.same-assets.com/3054329260/2344891104.png" alt="Client 2" className="h-12 object-contain grayscale hover:grayscale-0 transition-all" />
            <img src="https://ext.same-assets.com/3054329260/2144326699.png" alt="Client 3" className="h-12 object-contain grayscale hover:grayscale-0 transition-all" />
            <img src="https://ext.same-assets.com/3054329260/1261780770.png" alt="Client 4" className="h-12 object-contain grayscale hover:grayscale-0 transition-all" />
            <img src="https://ext.same-assets.com/3054329260/3285877443.png" alt="Client 5" className="h-12 object-contain grayscale hover:grayscale-0 transition-all" />
            <img src="https://ext.same-assets.com/3054329260/4143333439.png" alt="Client 6" className="h-12 object-contain grayscale hover:grayscale-0 transition-all" />
          </div>
        </div>
      </section>

      {/* About Section */}
      <section id="about" className="py-20 bg-white">
        <div className="container mx-auto px-6">
          <div className="text-center mb-16">
            <h2 className="text-4xl font-bold text-blue-800 mb-4">ABOUT US</h2>
            <div className="w-20 h-1 bg-blue-400 mx-auto"></div>
          </div>

          <div className="grid md:grid-cols-2 gap-12">
            <div>
              <h3 className="text-2xl font-bold text-blue-700 mb-4">Our Vision</h3>
              <p className="text-gray-600 leading-relaxed">
                At PT Dua Shandie Bersaudara, our vision is to provide the best customer service by empowering
                individuals and businesses to confidently navigate the world of telecommunications and
                Information and Communication Technology (ICT). We strive to be a trusted partner, offering
                innovative management services that help our clients achieve their goals and secure a
                prosperous future.
              </p>
            </div>

            <div>
              <h3 className="text-2xl font-bold text-blue-700 mb-4">Our Mission</h3>
              <div className="space-y-4">
                <p className="text-gray-600">
                  1. Advance the rapid development of smart, sustainable digital infrastructure and platforms
                  that are affordable and accessible to everyone.
                </p>
                <p className="text-gray-600">
                  2. Nurture top-class digital talent to enhance the nation's digital capabilities and
                  increase digital adoption.
                </p>
                <p className="text-gray-600">
                  3. Organize the digital ecosystem to deliver superior customer experiences.
                </p>
              </div>
            </div>
          </div>

          <div className="text-center mt-12">
            <Button variant="outline" className="border-blue-400 text-blue-600 hover:bg-blue-50">
              Read More
              <ChevronRight className="ml-2 h-4 w-4" />
            </Button>
          </div>
        </div>
      </section>

      {/* Company Info Section */}
      <section className="py-20 bg-gray-50">
        <div className="container mx-auto px-6">
          <div className="grid lg:grid-cols-2 gap-12 items-center">
            <div>
              <h2 className="text-3xl font-bold text-blue-800 mb-4">
                PT Dua Shandie Bersaudara <span className="text-blue-600">52 Branches</span> Serving ISP & Fiber Co
              </h2>
              <p className="text-gray-600 mb-6 leading-relaxed">
                PT Dua Shandie Bersaudara is committed to providing cutting-edge solutions in the ISP and fiber
                optic industry with an extensive branch network. We offer reliable professional services and
                technical support to ensure your needs are optimally met. With 52 branches nationwide, we are
                dedicated to delivering the best service across the country.
              </p>
              <p className="text-gray-600 mb-8 leading-relaxed">
                Our <span className="text-blue-600 font-semibold">Monitoring Work Order</span> allows you to
                track and manage every stage of the work efficiently. We provide full visibility into project
                progress, ensuring that all tasks are completed on time and to quality standards.
              </p>

              <div className="space-y-4">
                <div className="flex items-center space-x-3">
                  <div className="w-3 h-3 bg-blue-500 rounded-full"></div>
                  <span className="text-blue-700 font-semibold">Monitoring Work Order</span>
                </div>
                <div className="flex items-center space-x-3">
                  <div className="w-3 h-3 bg-blue-500 rounded-full"></div>
                  <span className="text-blue-700 font-semibold">Branch List</span>
                </div>
              </div>
            </div>

            <div className="space-y-6">
              <Card className="border-blue-200">
                <CardContent className="p-6">
                  <h4 className="font-bold text-blue-800 mb-3 flex items-center">
                    <Settings className="mr-2 h-5 w-5" />
                    Monitoring Work Order
                  </h4>
                  <img
                    src="https://ext.same-assets.com/3054329260/2727405777.png"
                    alt="Monitoring Work Order Screenshot"
                    className="w-full rounded-lg"
                  />
                </CardContent>
              </Card>
            </div>
          </div>
        </div>
      </section>

      {/* Resources Section */}
      <section className="py-20 bg-white">
        <div className="container mx-auto px-6">
          <div className="text-center mb-16">
            <h2 className="text-3xl font-bold text-blue-800 mb-6">
              Current Resources to Support ISP & Fiber Co Services
            </h2>
            <p className="text-gray-600 max-w-3xl mx-auto mb-8">
              We are committed to providing top-notch support services for ISP & Fiber Co. Our current resources include:
            </p>
            <ul className="text-left max-w-2xl mx-auto space-y-2 text-gray-600">
              <li className="flex items-center"><span className="w-2 h-2 bg-blue-500 rounded-full mr-3"></span>24/7 Technical Support Team</li>
              <li className="flex items-center"><span className="w-2 h-2 bg-blue-500 rounded-full mr-3"></span>Advanced Network Operations Center (NOC)</li>
              <li className="flex items-center"><span className="w-2 h-2 bg-blue-500 rounded-full mr-3"></span>Advanced Monitoring and Diagnostic Tools</li>
              <li className="flex items-center"><span className="w-2 h-2 bg-blue-500 rounded-full mr-3"></span>Comprehensive Customer Support Portal</li>
              <li className="flex items-center"><span className="w-2 h-2 bg-blue-500 rounded-full mr-3"></span>Extensive Knowledge Base and Documentation</li>
            </ul>
          </div>

          <div className="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-6">
            <Card className="text-center">
              <CardContent className="p-6">
                <Users className="h-12 w-12 text-blue-500 mx-auto mb-4" />
                <h4 className="font-bold text-gray-800 mb-2">Senior Manager - GM</h4>
                <p className="text-sm text-gray-600 mb-2">Operation Support System - Traffic & Delivery, Operations, Warehouse, Assets & Admin, GPS Monitoring, Dashboard</p>
                <p className="text-xs text-gray-500">Web Application Software</p>
              </CardContent>
            </Card>

            <Card className="text-center">
              <CardContent className="p-6">
                <Users className="h-12 w-12 text-blue-500 mx-auto mb-4" />
                <h4 className="font-bold text-gray-800 mb-2">Branch Manager</h4>
                <p className="text-sm text-gray-600 mb-2">Quantum Mobile</p>
                <p className="text-xs text-gray-500">Mobile Application</p>
              </CardContent>
            </Card>

            <Card className="text-center">
              <CardContent className="p-6">
                <Truck className="h-12 w-12 text-blue-500 mx-auto mb-4" />
                <h4 className="font-bold text-gray-800 mb-2">Traffic</h4>
                <p className="text-sm text-gray-600 mb-2">Vehicles</p>
                <p className="text-2xl font-bold text-blue-600">323</p>
              </CardContent>
            </Card>

            <Card className="text-center">
              <CardContent className="p-6">
                <Headphones className="h-12 w-12 text-blue-500 mx-auto mb-4" />
                <h4 className="font-bold text-gray-800 mb-2">Help Desk (24 Hours)</h4>
                <p className="text-sm text-gray-600 mb-2">Connectors</p>
                <p className="text-2xl font-bold text-blue-600">551</p>
              </CardContent>
            </Card>
          </div>
        </div>
      </section>

      {/* Services Section */}
      <section id="services" className="py-20 bg-gray-50">
        <div className="container mx-auto px-6">
          <div className="text-center mb-16">
            <h2 className="text-4xl font-bold text-blue-800 mb-4">SERVICES</h2>
            <p className="text-gray-600 max-w-3xl mx-auto">
              For the past 20 years, PT. Dua Shandie Bersaudara has been serving Telco Operation, Telco Infrastructure
              Companies (Tower, Fiber Optic & HFC), and Internet Service Providers.
            </p>
          </div>

          <div className="grid md:grid-cols-2 gap-8">
            <Card className="hover:shadow-lg transition-shadow">
              <CardContent className="p-8">
                <div className="w-16 h-16 bg-blue-100 rounded-lg flex items-center justify-center mb-6">
                  <Settings className="h-8 w-8 text-blue-600" />
                </div>
                <h3 className="text-xl font-bold text-blue-800 mb-4">Project Planning & Design</h3>
                <p className="text-gray-600 mb-6">
                  We provide comprehensive project planning and design services to ensure every detail of your
                  project is well-crafted.
                </p>
                <Button variant="link" className="text-blue-600 p-0">
                  Click to see details
                </Button>
              </CardContent>
            </Card>

            <Card className="hover:shadow-lg transition-shadow">
              <CardContent className="p-8">
                <div className="w-16 h-16 bg-blue-100 rounded-lg flex items-center justify-center mb-6">
                  <Warehouse className="h-8 w-8 text-blue-600" />
                </div>
                <h3 className="text-xl font-bold text-blue-800 mb-4">Inside Plant (ISP) & Outside Plant (OSP)</h3>
                <p className="text-gray-600 mb-6">
                  Procurement and installation of systems for telecommunications infrastructure both inside and
                  outside buildings, including fiber optics and other components.
                </p>
                <Button variant="link" className="text-blue-600 p-0">
                  Click to see details
                </Button>
              </CardContent>
            </Card>

            <Card className="hover:shadow-lg transition-shadow">
              <CardContent className="p-8">
                <div className="w-16 h-16 bg-blue-100 rounded-lg flex items-center justify-center mb-6">
                  <Wrench className="h-8 w-8 text-blue-600" />
                </div>
                <h3 className="text-xl font-bold text-blue-800 mb-4">Network Repair & Preventive Maintenance</h3>
                <p className="text-gray-600 mb-6">
                  Providing network repair and recovery services as well as preventive maintenance to ensure
                  your network continues to operate optimally.
                </p>
                <Button variant="link" className="text-blue-600 p-0">
                  Click to see details
                </Button>
              </CardContent>
            </Card>

            <Card className="hover:shadow-lg transition-shadow">
              <CardContent className="p-8">
                <div className="w-16 h-16 bg-blue-100 rounded-lg flex items-center justify-center mb-6">
                  <UserCheck className="h-8 w-8 text-blue-600" />
                </div>
                <h3 className="text-xl font-bold text-blue-800 mb-4">Service Management</h3>
                <p className="text-gray-600 mb-6">
                  Providing reliable management services to ensure your operations run smoothly.
                </p>
                <Button variant="link" className="text-blue-600 p-0">
                  Click to see details
                </Button>
              </CardContent>
            </Card>
          </div>
        </div>
      </section>

      {/* Contact CTA Section */}
      <section className="py-20 bg-blue-800 text-white">
        <div className="container mx-auto px-6 text-center">
          <h2 className="text-4xl font-bold mb-6">Contact Dua Shandie Bersaudara</h2>
          <p className="text-xl mb-8 max-w-3xl mx-auto">
            At Dua Shandie Bersaudara, we are dedicated to providing innovative solutions in telecommunications and
            fiber optics. Contact us today to learn more about our services and how we can help you achieve your goals.
          </p>
          <Button className="bg-white text-blue-800 hover:bg-gray-100 text-lg px-8 py-3">
            Contact Us
          </Button>
        </div>
      </section>

      {/* Projects Section */}
      <section id="portfolio" className="py-20 bg-white">
        <div className="container mx-auto px-6">
          <div className="text-center mb-16">
            <h2 className="text-4xl font-bold text-blue-800 mb-4">OUR PROJECTS</h2>
            <div className="w-20 h-1 bg-blue-400 mx-auto mb-6"></div>
            <p className="text-gray-600 max-w-3xl mx-auto">
              Explore our extensive portfolio showcasing our commitment to excellence in telecommunications and fiber optics.
            </p>
          </div>

          <div className="flex flex-wrap justify-center gap-4 mb-12">
            <Button variant="default" className="bg-blue-500 hover:bg-blue-600">All</Button>
            <Button variant="outline">New Installations</Button>
            <Button variant="outline">Maintenance</Button>
            <Button variant="outline">Dismantle</Button>
          </div>

          <div className="grid md:grid-cols-3 gap-8">
            <Card className="overflow-hidden hover:shadow-lg transition-shadow">
              <img
                src="https://ext.same-assets.com/3054329260/3557548677.jpeg"
                alt="Application Project"
                className="w-full h-48 object-cover"
              />
              <CardContent className="p-6">
                <h4 className="font-bold text-gray-800 mb-2">Application Project</h4>
                <p className="text-gray-600 text-sm">Advanced mobile applications.</p>
              </CardContent>
            </Card>

            <Card className="overflow-hidden hover:shadow-lg transition-shadow">
              <img
                src="https://ext.same-assets.com/3054329260/934090944.jpeg"
                alt="Product Development"
                className="w-full h-48 object-cover"
              />
              <CardContent className="p-6">
                <h4 className="font-bold text-gray-800 mb-2">Product Development</h4>
                <p className="text-gray-600 text-sm">Innovative product solutions that transform your business.</p>
              </CardContent>
            </Card>

            <Card className="overflow-hidden hover:shadow-lg transition-shadow">
              <img
                src="https://ext.same-assets.com/3054329260/410719654.jpeg"
                alt="Branding Solutions"
                className="w-full h-48 object-cover"
              />
              <CardContent className="p-6">
                <h4 className="font-bold text-gray-800 mb-2">Branding Solutions</h4>
                <p className="text-gray-600 text-sm">Branding strategies that enhance your brand identity and visibility.</p>
              </CardContent>
            </Card>
          </div>
        </div>
      </section>

      {/* Contact Section */}
      <section id="contact" className="py-20 bg-gray-50">
        <div className="container mx-auto px-6">
          <div className="text-center mb-16">
            <h2 className="text-4xl font-bold text-blue-800 mb-4">CONTACT US</h2>
            <p className="text-gray-600">
              Reach out to us for any inquiries, support, or to learn more about our services and solutions.
            </p>
          </div>

          <div className="grid lg:grid-cols-2 gap-12">
            <div className="space-y-8">
              <div>
                <h3 className="text-xl font-bold text-blue-800 mb-6">Address</h3>
                <div className="flex items-start space-x-3">
                  <MapPin className="h-6 w-6 text-blue-600 mt-1 flex-shrink-0" />
                  <p className="text-gray-600">
                    Harmoni Plaza, Complex, Jl. Suryopranoto No.2 Block K 14-16, Petojo Utara,
                    Gambir District, Central Jakarta City, Special Capital Region of Jakarta 10130
                  </p>
                </div>
              </div>

              <div>
                <h3 className="text-xl font-bold text-blue-800 mb-4">Call Us</h3>
                <div className="flex items-center space-x-3">
                  <Phone className="h-5 w-5 text-blue-600" />
                  <span className="text-gray-600">0216319077</span>
                </div>
              </div>

              <div>
                <h3 className="text-xl font-bold text-blue-800 mb-4">Email Us</h3>
                <div className="flex items-center space-x-3">
                  <Mail className="h-5 w-5 text-blue-600" />
                  <span className="text-gray-600">itduashandiebersaudara@gmail.com</span>
                </div>
              </div>
            </div>

            <div>
              <Card>
                <CardContent className="p-8">
                  <form className="space-y-6">
                    <div className="grid md:grid-cols-2 gap-4">
                      <Input placeholder="Company Name" />
                      <Input placeholder="Your Name" />
                    </div>
                    <div className="grid md:grid-cols-2 gap-4">
                      <Input placeholder="Your Email" type="email" />
                      <Input placeholder="Phone" />
                    </div>
                    <Input placeholder="WhatsApp" />
                    <Input placeholder="Subject" />
                    <Textarea placeholder="Message" className="min-h-[120px]" />
                    <Button className="w-full bg-blue-500 hover:bg-blue-600">
                      Send Message
                    </Button>
                  </form>
                </CardContent>
              </Card>
            </div>
          </div>
        </div>
      </section>

      {/* Newsletter Section */}
      <section className="py-16 bg-white">
        <div className="container mx-auto px-6 text-center">
          <h2 className="text-3xl font-bold text-gray-800 mb-4">Join DSB</h2>
          <p className="text-gray-600 mb-8">
            Subscribe to Dua Shandie Bersaudara and get the latest news about our products and services!
          </p>
          <div className="max-w-md mx-auto flex gap-4">
            <Input placeholder="Your Email" className="flex-1" />
            <Button className="bg-blue-500 hover:bg-blue-600">Subscribe</Button>
          </div>
        </div>
      </section>

      {/* Footer */}
      <footer className="bg-gray-100 py-12">
        <div className="container mx-auto px-6">
          <div className="grid md:grid-cols-2 gap-8">
            <div>
              <div className="flex items-center space-x-2 mb-4">
                <div className="w-8 h-8 bg-blue-600 rounded-md flex items-center justify-center">
                  <span className="text-white font-bold text-lg">D</span>
                </div>
                <span className="text-xl font-bold text-gray-800">DUA SHANDIE BERSAUDARA</span>
              </div>
              <p className="text-gray-600 mb-4">
                Harmoni Plaza, Complex, Jl. Suryopranoto No.2 Block K 14-16, Petojo Utara,<br />
                Gambir District, Central Jakarta City, Special Capital Region of Jakarta 10130
              </p>
              <p className="text-gray-600 mb-2"><strong>Phone:</strong> 0216319077</p>
              <p className="text-gray-600"><strong>Email:</strong> itduashandiebersaudara@gmail.com</p>
            </div>

            <div>
              <h4 className="text-lg font-bold text-gray-800 mb-4">Social Media</h4>
              <p className="text-gray-600 mb-4">Connect with us for the latest updates on social media</p>
              <div className="flex space-x-4">
                <Button variant="outline" size="icon">
                  <span className="sr-only">LinkedIn</span>
                  👔
                </Button>
                <Button variant="outline" size="icon">
                  <span className="sr-only">Facebook</span>
                  📘
                </Button>
                <Button variant="outline" size="icon">
                  <span className="sr-only">Instagram</span>
                  📷
                </Button>
              </div>
            </div>
          </div>

          <div className="border-t border-gray-200 mt-8 pt-8 text-center">
            <p className="text-gray-600">
              © 2024 <strong>Dua Shandie Bersaudara</strong> All Rights Reserved
            </p>
          </div>
        </div>
      </footer>
    </div>
  )
}
